
/*! \file    
**********************************************************************************
* Title:                            Discretix SST API Source file
*
* Filename:                         util.c
*
* Project, Target, subsystem:       SST Host IF
* 
* Created:                          01.07.2007
*
* Modified:
*
* \Author                           Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#include "DX_VOS_Mem.h"
#include "SEPDriver.h"
#include "error.h"
#include "sst_host_util.h"

/*
* SST_SendMsgGetResponse
Description: This function implements a Native protocol sequence. It sends input
parameters to SeP and passes output parameters to Host.
Note:        It sends only one buffer.
*/
DxError_t SST_SendOneMsgGetResponse( DxUint32_t *aInputBufferParam_ptr,
                                     DxUint32_t  aInputBufferParamLengthInBytes,
                                     DxUint32_t *aOutputBuffer_ptr,
                                     DxUint32_t  aOutputBufferParamLengthInBytes)
{
    DxUint32_t          sramOffset = 0;
    DxError_t           drvRC = DX_OK;

    /************************************************************************/
    /*  Start message                                                       */
    /************************************************************************/
    SEPDriver_StartMessage(&sramOffset);

    /************************************************************************/
    /*  Send message                                                        */
    /************************************************************************/
    drvRC = SEPDriver_WriteParamater((DxUint32_t)aInputBufferParam_ptr,
                              aInputBufferParamLengthInBytes,
                              aInputBufferParamLengthInBytes,
                             &sramOffset, 
                              DX_ENDIANESS_FLAG);
    if(drvRC != DX_OK)
    {
        goto exit_send_one_msg_get_response;
    }

    /************************************************************************/
    /* End message                                                          */
    /************************************************************************/
    SEPDriver_EndMessage(sramOffset);

    /************************************************************************/
    /* Wait for response                                                    */
    /************************************************************************/
    drvRC = SEPDriver_POLL_FOR_REPONSE();
    if (DX_OK != drvRC)
        goto exit_send_one_msg_get_response;

    /************************************************************************/
    /* Start incoming message                                               */
    /************************************************************************/
    SEPDriver_StartIncomingMessage(&sramOffset);

    /************************************************************************/
    /* Read incoming message                                                */
    /************************************************************************/
    drvRC = SEPDriver_ReadParamater((DxUint32_t)aOutputBuffer_ptr,
                            aOutputBufferParamLengthInBytes,
                            aOutputBufferParamLengthInBytes,
                            &sramOffset, 
                            DX_ENDIANESS_FLAG);
    if(drvRC != DX_OK)
    {
        goto exit_send_one_msg_get_response;
    }

exit_send_one_msg_get_response:
    return drvRC;
}
